/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;

public class GetInfo {
    public static final String proc_Ide_Media = "/proc/ide/hdx/media";
    public static BufferedWriter out;
    public static BufferedWriter outLog;
    public static String blanks_25;
    public static String blanks_12;
    public static byte[] oneNull;
    public static String nullChar;
    private static final String TRACE_MASKT = "XSETGI_T";
    private static final String TRACE_MASKF = "XSETGI_F";
    private static final String TRACE_MASKD = "XSETGI_D";

    public static void main(String[] args) {
        String mountPoint = "/mnt/dos/";
        String dosDir = "pciinfo/";
        String dosFile = "pci_info.out";
        String outputDir = "data/pciinfo/";
        String headingConstant = "A00M_VPD_";
        String[] dataStreams = new String[2];
        boolean TESTMODE = false;
        Trace.trace(TRACE_MASKT, "-> GetInfo.main");
        try {
            int pos;
            String line;
            String errorStream;
            String commandStream;
            if (args.length > 0) {
                if (args[0].startsWith("--h")) {
                    Trace.trace(TRACE_MASKT, "USAGE: java GetInfo <loc> \n       where <loc> is a replacement location for a DOS mountpoint\n       i.e.  java GetInfo /home/<userid>/linuxhmc/data/");
                    System.exit(1);
                } else {
                    mountPoint = args[0];
                    TESTMODE = true;
                    Trace.trace(TRACE_MASKT, "TestMode: Change mountPoint to " + args[0]);
                }
            }
            out = new BufferedWriter(new FileWriter(outputDir + "sys_info.out"));
            outLog = new BufferedWriter(new FileWriter(outputDir + "sys_info.log"));
            if (!TESTMODE) {
                dataStreams = GetInfo.executeCommand("mount " + mountPoint);
                commandStream = dataStreams[0];
                errorStream = dataStreams[1];
                if (errorStream.length() != 0) {
                    int pos2 = errorStream.indexOf("already mounted");
                    if (pos2 != -1) {
                        Trace.trace(TRACE_MASKT, mountPoint + " already mounted - go on");
                        outLog.write(mountPoint + " already mounted - go on\n");
                    } else {
                        Trace.trace(TRACE_MASKT, mountPoint + " Mount ERROR!!" + errorStream);
                        outLog.write(mountPoint + " Mount ERROR!!" + errorStream + "\n");
                    }
                } else {
                    Trace.trace(TRACE_MASKT, mountPoint + " mounted OK");
                    outLog.write(mountPoint + " mounted OK\n");
                }
            }
            dataStreams = GetInfo.executeCommand("cat " + mountPoint + dosDir + dosFile);
            commandStream = dataStreams[0];
            errorStream = dataStreams[1];
            if (errorStream.length() != 0) {
                Trace.trace(TRACE_MASKT, "File " + mountPoint + dosDir + dosFile + " Read ERROR!!\n" + errorStream + "\n");
                outLog.write("File " + mountPoint + dosDir + dosFile + " Read ERROR!!\n" + errorStream + "\n");
            } else {
                Trace.trace(TRACE_MASKT, "File " + mountPoint + dosDir + dosFile + " read cleanly\n");
                outLog.write("File " + mountPoint + dosDir + dosFile + " read cleanly\n");
            }
            StringReader sr = new StringReader(commandStream);
            BufferedReader in = new BufferedReader(sr);
            String modelNumber = "????-???";
            String serialNumber = "?????????";
            String biosLevel = "???????";
            String vendorID = "????";
            String deviceID = "????";
            boolean modelFound = false;
            boolean biosFound = false;
            boolean serialFound = false;
            do {
                boolean done;
                String temp;
                if ((line = in.readLine()) == null) continue;
                pos = line.indexOf("IBM_Model =");
                if (pos != -1 && !modelFound) {
                    modelFound = true;
                    outLog.write("Found Model #: " + line + "\n");
                    temp = line.substring(pos);
                    modelNumber = line.substring(temp.indexOf("=") + 1).trim();
                    GetInfo.writeOut((headingConstant + "PCTM" + nullChar + blanks_25).substring(0, 26) + (modelNumber + nullChar + blanks_12).substring(0, 13) + "VPTM" + nullChar + "\n");
                    continue;
                }
                pos = line.indexOf("System_Serial_Number =");
                if (pos != -1 && !serialFound) {
                    serialFound = true;
                    outLog.write("Found Serial #: " + line + "\n");
                    temp = line.substring(pos);
                    serialNumber = line.substring(temp.indexOf("=") + 1).trim();
                    GetInfo.writeOut((headingConstant + "PCSN" + nullChar + blanks_25).substring(0, 26) + (serialNumber + nullChar + blanks_12).substring(0, 13) + "VPSN" + nullChar + "\n");
                    continue;
                }
                pos = line.indexOf("IBM_BIOS_Level =");
                if (pos != -1 && !biosFound) {
                    biosFound = true;
                    outLog.write("Found Bios Level: " + line + "\n");
                    temp = line.substring(pos);
                    biosLevel = line.substring(temp.indexOf("=") + 1).trim();
                    GetInfo.writeOut((headingConstant + "PCBIOS" + nullChar + blanks_25).substring(0, 26) + (biosLevel + nullChar + blanks_12).substring(0, 13) + "VPBS" + nullChar + "\n");
                    continue;
                }
                pos = line.indexOf("thernet");
                if (pos != -1) {
                    pos = line.indexOf("]");
                    if (pos == -1) continue;
                    outLog.write("Ethernet detected: " + line + "\n");
                    done = false;
                    do {
                        if ((line = in.readLine()) == null) continue;
                        pos = line.indexOf("Vendor ID");
                        if (pos != -1) {
                            outLog.write("Ethernet VendorID detected: " + line + "\n");
                            temp = line.substring(pos);
                            pos = temp.indexOf("=") + 1;
                            vendorID = temp.substring(pos, pos + 6).trim();
                            continue;
                        }
                        pos = line.indexOf("Device ID");
                        if (pos == -1) continue;
                        outLog.write("Ethernet DeviceID detected: " + line + "\n");
                        temp = line.substring(pos);
                        pos = temp.indexOf("=") + 1;
                        deviceID = temp.substring(pos, pos + 6).trim();
                        done = true;
                    } while (line != null && !done);
                    GetInfo.writeOut((headingConstant + "PCEN" + nullChar + blanks_25).substring(0, 26) + (vendorID + deviceID + nullChar + blanks_12).substring(0, 13) + "VPEN" + nullChar + "\n");
                    continue;
                }
                pos = line.indexOf("oken");
                if (pos == -1 || (pos = line.indexOf("]")) == -1) continue;
                outLog.write("TokenRing detected: " + line + "\n");
                done = false;
                do {
                    if ((line = in.readLine()) == null) continue;
                    pos = line.indexOf("Vendor ID");
                    if (pos != -1) {
                        outLog.write("TokenRing VendorID detected: " + line + "\n");
                        temp = line.substring(pos);
                        pos = temp.indexOf("=") + 1;
                        vendorID = temp.substring(pos, pos + 6).trim();
                        continue;
                    }
                    pos = line.indexOf("Device ID");
                    if (pos == -1) continue;
                    outLog.write("TokenRing DeviceID detected: " + line + "\n");
                    temp = line.substring(pos);
                    pos = temp.indexOf("=") + 1;
                    deviceID = temp.substring(pos, pos + 6).trim();
                    done = true;
                } while (line != null && !done);
                GetInfo.writeOut((headingConstant + "PCTR" + nullChar + blanks_25).substring(0, 26) + (vendorID + deviceID + nullChar + blanks_12).substring(0, 13) + "VPTR" + nullChar + "\n");
            } while (line != null);
            Trace.trace(TRACE_MASKT, "modelNumber = [" + modelNumber + "]");
            Trace.trace(TRACE_MASKT, "serialNumber = [" + serialNumber + "]");
            Trace.trace(TRACE_MASKT, "biosLevel = [" + biosLevel + "]");
            outLog.write("Assume a floppy drive exists\n");
            GetInfo.writeOut((headingConstant + "PCDD_" + "FD0" + nullChar + blanks_25).substring(0, 26) + (nullChar + blanks_12).substring(0, 13) + "VPDD" + nullChar + "\n");
            outLog.write("Assume a planar based fixed disk controller\n");
            GetInfo.writeOut((headingConstant + "PCFD" + nullChar + blanks_25).substring(0, 26) + ("PLANAR" + nullChar + blanks_12).substring(0, 13) + "VPFD" + nullChar + "\n");
            String hdName = "hda";
            String[] type_and_model = GetInfo.readIde('a');
            String type = type_and_model[0];
            String model = type_and_model[1];
            String dasdSize = "??????";
            if (type != "") {
                GetInfo.writeOut((headingConstant + "PC" + type + "HDA" + nullChar + blanks_25).substring(0, 26) + ("######" + nullChar + blanks_12).substring(0, 13) + "VP" + type.substring(0, 2) + nullChar + "\n");
                if (type.equals("HD_")) {
                    dasdSize = GetInfo.getDasdSize("ide0", hdName);
                    GetInfo.writeOut((headingConstant + "PCDS_HDA" + nullChar + blanks_25).substring(0, 26) + (dasdSize + nullChar + blanks_12).substring(0, 13) + "VPDS" + nullChar + "\n");
                    GetInfo.writeOut((headingConstant + "PCDID_HDA" + nullChar + blanks_25).substring(0, 26) + (model + nullChar + blanks_12).substring(0, 13) + "VPDM" + nullChar + "\n");
                } else {
                    GetInfo.writeOut((headingConstant + "PCCDID_HDA" + nullChar + blanks_25).substring(0, 26) + (model + nullChar + blanks_12).substring(0, 13) + "VP" + type.substring(0, 2) + nullChar + "\n");
                }
            }
            hdName = "hdb";
            type_and_model = GetInfo.readIde('b');
            type = type_and_model[0];
            model = type_and_model[1];
            if (type != "") {
                GetInfo.writeOut((headingConstant + "PC" + type + "HDB" + nullChar + blanks_25).substring(0, 26) + ("######" + nullChar + blanks_12).substring(0, 13) + "VP" + type.substring(0, 2) + nullChar + "\n");
                if (type.equals("HD_")) {
                    dasdSize = GetInfo.getDasdSize("ide0", hdName);
                    GetInfo.writeOut((headingConstant + "PCDS_HDB" + nullChar + blanks_25).substring(0, 26) + (dasdSize + nullChar + blanks_12).substring(0, 13) + "VPDS" + nullChar + "\n");
                    GetInfo.writeOut((headingConstant + "PCDID_HDB" + nullChar + blanks_25).substring(0, 26) + (model + nullChar + blanks_12).substring(0, 13) + "VPDM" + nullChar + "\n");
                } else {
                    GetInfo.writeOut((headingConstant + "PCCDID_HDB" + nullChar + blanks_25).substring(0, 26) + (model + nullChar + blanks_12).substring(0, 13) + "VP" + type.substring(0, 2) + nullChar + "\n");
                }
            }
            hdName = "hdc";
            type_and_model = GetInfo.readIde('c');
            type = type_and_model[0];
            model = type_and_model[1];
            if (type != "") {
                GetInfo.writeOut((headingConstant + "PC" + type + "HDC" + nullChar + blanks_25).substring(0, 26) + ("######" + nullChar + blanks_12).substring(0, 13) + "VP" + type.substring(0, 2) + nullChar + "\n");
                if (type.equals("HD_")) {
                    dasdSize = GetInfo.getDasdSize("ide1", hdName);
                    GetInfo.writeOut((headingConstant + "PCDS_HDC" + nullChar + blanks_25).substring(0, 26) + (dasdSize + nullChar + blanks_12).substring(0, 13) + "VPDS" + nullChar + "\n");
                    GetInfo.writeOut((headingConstant + "PCDID_HDC" + nullChar + blanks_25).substring(0, 26) + (model + nullChar + blanks_12).substring(0, 13) + "VPDM" + nullChar + "\n");
                } else {
                    GetInfo.writeOut((headingConstant + "PCCDID_HDC" + nullChar + blanks_25).substring(0, 26) + (model + nullChar + blanks_12).substring(0, 13) + "VP" + type.substring(0, 2) + nullChar + "\n");
                }
            }
            hdName = "hdd";
            type_and_model = GetInfo.readIde('d');
            type = type_and_model[0];
            model = type_and_model[1];
            if (type != "") {
                GetInfo.writeOut((headingConstant + "PC" + type + "HDD" + nullChar + blanks_25).substring(0, 26) + ("######" + nullChar + blanks_12).substring(0, 13) + "VP" + type.substring(0, 2) + nullChar + "\n");
                if (type.equals("HD_")) {
                    dasdSize = GetInfo.getDasdSize("ide1", hdName);
                    GetInfo.writeOut((headingConstant + "PCDS_HDD" + nullChar + blanks_25).substring(0, 26) + (dasdSize + nullChar + blanks_12).substring(0, 13) + "VPDS" + nullChar + "\n");
                    GetInfo.writeOut((headingConstant + "PCDID_HDD" + nullChar + blanks_25).substring(0, 26) + (model + nullChar + blanks_12).substring(0, 13) + "VPDM" + nullChar + "\n");
                } else {
                    GetInfo.writeOut((headingConstant + "PCCDID_HDD" + nullChar + blanks_25).substring(0, 26) + (model + nullChar + blanks_12).substring(0, 13) + "VP" + type.substring(0, 2) + nullChar + "\n");
                }
            }
            String proc_Meminfo = "/proc/meminfo";
            String memory = "?????";
            dataStreams = GetInfo.executeCommand("cat " + proc_Meminfo);
            commandStream = dataStreams[0];
            errorStream = dataStreams[1];
            if (errorStream.length() != 0) {
                Trace.trace(TRACE_MASKT, "Error performing  cat " + proc_Meminfo + "; " + errorStream);
                outLog.write("Error performing  cat " + proc_Meminfo + "; " + errorStream + "\n");
            } else {
                Trace.trace(TRACE_MASKT, "File " + proc_Meminfo + " read cleanly");
                outLog.write("File " + proc_Meminfo + " read cleanly\n");
            }
            sr = new StringReader(commandStream);
            in = new BufferedReader(sr);
            do {
                if ((line = in.readLine()) == null || (pos = line.indexOf("MemTotal:")) == -1) continue;
                outLog.write("MemTotal detected: " + line + "\n");
                memory = line.substring(line.indexOf(":") + 1).trim();
                memory = memory.substring(0, memory.indexOf(" ") - 1);
                GetInfo.writeOut((headingConstant + "PCMS" + nullChar + blanks_25).substring(0, 26) + (memory + nullChar + blanks_12).substring(0, 13) + "VPMS" + nullChar + "\n");
            } while (line != null);
            Trace.trace(TRACE_MASKT, "memory = [" + memory + " kB]");
            out.close();
            outLog.close();
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKT, "caught IOException: " + e);
            try {
                outLog.write("caught IOException: ");
            }
            catch (IOException e2) {
                // empty catch block
            }
            e.printStackTrace();
        }
        Trace.trace(TRACE_MASKT, "<- GetInfo.main");
    }

    private static String[] executeCommand(String command) {
        String cmdResults = new String("");
        String errorResults = new String("");
        String[] results = new String[2];
        try {
            String errorLine;
            String line;
            String[] commandArray = GetInfo.getCommandArray(command);
            Process pid = Runtime.getRuntime().exec(commandArray);
            BufferedReader in = new BufferedReader(new InputStreamReader(pid.getInputStream()));
            do {
                if ((line = in.readLine()) == null) continue;
                cmdResults = cmdResults + line + "\n";
            } while (line != null);
            BufferedReader inError = new BufferedReader(new InputStreamReader(pid.getErrorStream()));
            do {
                if ((errorLine = inError.readLine()) == null) continue;
                errorResults = errorResults + errorLine + "\n";
            } while (errorLine != null);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKT, "caught IOException: " + e.getMessage());
            e.printStackTrace();
        }
        catch (Throwable e) {
            Trace.trace(TRACE_MASKT, "caught Exception: " + e.getMessage());
            e.printStackTrace();
        }
        results[0] = cmdResults;
        results[1] = errorResults;
        return results;
    }

    private static String[] getCommandArray(String command) {
        String[] commandArray = new String[]{"bash", "-c", command};
        return commandArray;
    }

    private static void writeOut(String output) throws IOException {
        try {
            out.write(output);
            outLog.write(output);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKT, "caught IOException: " + e);
            e.printStackTrace();
        }
    }

    private static String[] readIde(char abcd) throws IOException {
        int pos;
        String proc_Ide_Model = "/proc/ide/hdx/model";
        String[] returnValues = new String[]{"", ""};
        String type = "?????";
        String modelName = "???????????";
        String temp = proc_Ide_Media;
        temp = temp.replace('x', abcd);
        String[] dataStreams = GetInfo.executeCommand("cat " + temp);
        String commandStream = dataStreams[0];
        String errorStream = dataStreams[1];
        if (errorStream.length() != 0) {
            pos = errorStream.indexOf("No such");
            if (pos != -1) {
                type = "";
                modelName = "";
                Trace.trace(TRACE_MASKT, "IDE Device hd" + abcd + " not found - go on");
                outLog.write("IDE Device hd" + abcd + " not found - go on\n");
            } else {
                Trace.trace(TRACE_MASKT, "Error performing  cat " + temp + "; " + errorStream + "\n");
                outLog.write("Error performing  cat " + temp + "; " + errorStream + "\n");
            }
        } else {
            type = commandStream.trim();
            Trace.trace(TRACE_MASKT, "cat " + temp + ", found hd" + abcd + " = [" + type + "]");
            outLog.write("cat " + temp + ", found hd" + abcd + " = [" + type + "]\n");
        }
        if (!type.equals("")) {
            temp = proc_Ide_Model;
            temp = temp.replace('x', abcd);
            dataStreams = GetInfo.executeCommand("cat " + temp);
            commandStream = dataStreams[0];
            errorStream = dataStreams[1];
            if (errorStream.length() != 0) {
                Trace.trace(TRACE_MASKT, "Error performing  cat " + temp + "; " + errorStream);
                outLog.write("Error performing  cat " + temp + "; " + errorStream + "\n");
            } else {
                modelName = (commandStream + blanks_12).substring(0, 12).trim();
                Trace.trace(TRACE_MASKT, "cat " + temp + ", found hd" + abcd + " = [" + modelName + "]");
                outLog.write("cat " + temp + ", found hd" + abcd + " = [" + modelName + "]\n");
                if (type.equals("disk")) {
                    type = "HD_";
                } else if (type.equals("cdrom")) {
                    pos = modelName.toUpperCase().indexOf("DVD");
                    type = pos != -1 ? "DV_" : "CD_";
                }
            }
        }
        returnValues[0] = type;
        returnValues[1] = modelName.toUpperCase();
        return returnValues;
    }

    private static String getDasdSize(String ideBus, String hdName) throws IOException {
        String proc_String = "/proc/ide/";
        String dasdSize = "?????";
        String temp = proc_String + ideBus + "/" + hdName + "/capacity";
        String[] dataStreams = GetInfo.executeCommand("cat " + temp);
        String commandStream = dataStreams[0];
        String errorStream = dataStreams[1];
        if (errorStream.length() != 0) {
            outLog.write("Error performing  cat " + temp + "; " + errorStream + "\n");
        } else {
            int intSize = Integer.decode(commandStream.trim());
            dasdSize = String.valueOf(intSize / 2048);
            Trace.trace(TRACE_MASKT, "cat " + temp + ", found dasd size = " + dasdSize);
            outLog.write("cat " + temp + ", found dasd size = " + dasdSize + " Mb\n");
        }
        return dasdSize;
    }

    static {
        blanks_25 = "                         ";
        blanks_12 = "            ";
        oneNull = new byte[]{0};
        nullChar = new String(oneNull);
    }
}

